package org.msh.tb.bd.tbforms.query.tb12;

import org.msh.tb.bd.entities.enums.SmearStatus;
import org.msh.tb.entities.enums.CaseState;
import org.msh.tb.entities.enums.Gender;

/**
 * Created by Mauricio Santos on 20/04/2017.
 */
public enum TB12Column {

    TOTAL_REGISTERED("manag.pulmonary.totpatients", null, null),
    SMEAR_NEGATIVE("manag.pulmonary.microscopy.negative", "U5J4rL3XJ68", "tHQVATdyPkS"),
    SMEAR_POSITIVE("manag.pulmonary.microscopy.positive", "tOur9RRWbsT", "dgzflTycSBS"),
    OUTCOME_DIED("CaseState.DIED", "gZRq9NenlO4", "vWayzEZiQIu"),
    OUTCOME_FAILURE("CaseState.FAILED", "yDOhmYNwxkS", "y1n5iAeEDW7"),
    OUTCOME_LOST_TO_FOLLOW_UP("CaseState.DEFAULTED", "QYbnm6fDnrQ", "s58ZGBxn56c"),
    OUTCOME_TRANSFERRED_OUT("CaseState.TRANSFERRED_OUT", "Pq3jDs7oqLC", "EcX6rnhhesG"),
    OUTCOME_NOT_EVALUATED("CaseState.NOT_EVALUATED", "Z4RTcKCdvIm", "nPS17Vy0DP8"),
    GRAND_TOTAL("manag.pulmonary.grandtotal", null, null);

    String key;

    // Category option combo id, in DHIS2, used during DHIS2 integration
    // check in DHIS2: /api/24/categoryCombos/dhZ1WRGrUSd?fields=categoryOptionCombos[id,name]
    String maleCocDHIS2Id;
    String femaleCocDHIS2Id;

    TB12Column(String k, String maleCocDHIS2Id, String femaleCocDHIS2Id){
        this.key = k;
        this.maleCocDHIS2Id = maleCocDHIS2Id;
        this.femaleCocDHIS2Id = femaleCocDHIS2Id;
    }

    public String getKey(){
        return key;
    }

    public String getMaleCocDHIS2Id() {
        return maleCocDHIS2Id;
    }

    public String getFemaleCocDHIS2Id() {
        return femaleCocDHIS2Id;
    }

    /**
     * This method will return the TB12Column enum equivalent to the Outcome passed as parameter
     * @param c Case State - Outcome
     * @return The TB12Column enum based on the Outcome
     */
    public static TB12Column getOutcomeTB12Column(CaseState c){

        if (c == null) {
            throw new RuntimeException("CaseState can't be null");
        }

        switch (c) {
            case DIED:
            case DIED_NOTTB:
                return TB12Column.OUTCOME_DIED;
            case FAILED:
                return TB12Column.OUTCOME_FAILURE;
            case DEFAULTED:
                return TB12Column.OUTCOME_LOST_TO_FOLLOW_UP;
            case TRANSFERRED_OUT:
                return TB12Column.OUTCOME_TRANSFERRED_OUT;
            case NOT_EVALUATED:
            default:
                return TB12Column.OUTCOME_NOT_EVALUATED;
        }
    }

    /**
     * This method will return the TB12Column enum equivalent to the Smear Status passed as parameter
     * @param s Smear Status
     * @return The TB12Column enum based on the Smear Status
     */
    public static TB12Column getSmearTB12Column(SmearStatus s){
        if (s == null) {
            throw new RuntimeException("Smear Status can't be null");
        }

        switch (s) {
            case SMEAR_POSITIVE:
                return TB12Column.SMEAR_POSITIVE;
            case SMEAR_NEGATIVE:
                return TB12Column.SMEAR_NEGATIVE;
            case NOT_EVALUATED:
                return TB12Column.OUTCOME_NOT_EVALUATED;
        }

        throw new RuntimeException("Smear Status not valid");
    }

    public static String getDHIS2CocId(SmearStatus s, Gender g) {
        TB12Column column = TB12Column.getSmearTB12Column(s);

        switch(g) {
            case MALE:
                return column.getMaleCocDHIS2Id();
            case FEMALE:
                return column.getFemaleCocDHIS2Id();
        }

        throw new RuntimeException("TB12Column Smear Status: coc id not found");
    }

    public static String getDHIS2CocId(CaseState c, Gender g) {
        TB12Column column = TB12Column.getOutcomeTB12Column(c);

        switch(g) {
            case MALE:
                return column.getMaleCocDHIS2Id();
            case FEMALE:
                return column.getFemaleCocDHIS2Id();
        }

        throw new RuntimeException("TB12Column Outcome: coc id not found");
    }
}
